;[]------------------------------------------------------------[]
;|   FTOL.ASM -- Float to Long conversion                       |
;[]------------------------------------------------------------[]

;
;       C/C++ Run Time Library - Version 11.0
; 
;       Copyright (c) 1987, 2004 by Borland Software Corporation
;       All Rights Reserved.
; 

; $Revision: 9.7 $

        include RULES.ASI

Header@

;-----------------------------------------------------------------------
; __ftol
;
; Calls to __ftol are generated by the compiler for code
; that needs to convert a floating point type to an integral type.
;
; Input: floating point number on the top of the '87.
;
; Output: a (signed or unsigned) long in EAX
; All other registers preserved.
;
; Caution: Overflows are ignored.
;-----------------------------------------------------------------------

Code_Seg@

PubSym@ @_ftol$qv, <label near>, pascal ; temporary fix for C++ codegen bug

Func@   _ftol, _EXPFUNC, cdecl
Locals@ <int temp1>,<qword temp2>

        Link@

        fstcw   temp1.w0                ; save the control word
        fwait
        mov     ax, temp1.w0

        ; the last bit in 0c01h disables the invalid fpu op exception
        ; if the result overflows 64bits. this is done to remain
        ; consistent with casts to 32bit ints which can overflow
        ; w/o causing invalid fpu op.
        or      temp1, 0C01h            ; set rounding control to chop
        fldcw   temp1
        fistp   qword ptr temp2         ; convert to 64-bit integer
        mov     temp1.w0, ax
        fldcw   temp1.w0                ; restore the control word
        mov     eax, temp2.dd0          ; return LS 32 bits
        mov     edx, temp2.dd1          ;        MS 32 bits

        Unlink@
        Return@

EndFunc@ _ftol

Code_EndS@
        end
